<?php

require_once('util.php');
require_once('media.php');

class pb_Comment {
    protected $id;
    protected $mediaId = 0;
    protected $content = NULL;
    protected $date = NULL;
    protected $userId = 0;

    public function __construct($mediaId, $content, $date, $userId) {
        $this->mediaId = $mediaId;
        $this->content = $content;
        $this->date = $date;
        $this->userId = $userId;
    }
    public function getId() {
        return $this->id;
    }
    public function setId($id) {
        $this->id = $id;
    }
	public function getMediaId() {
        return $this->mediaId;
    }
	public function setMediaId($mediaId) {
        $this->mediaId = $mediaId;
    }
	public function getContent() {
        return $this->content;
    }
	public function setContent($content) {
        $this->content = $content;
    }
	public function getDate() {
        return $this->date;
    }
	public function setDate($date) {
        $this->date = $date;
    }
	public function getUserId() {
        return $this->userId;
    }
	public function setUserId($userId) {
        $this->userId = $userId;
    }
	public function insert() {
        // consider a transaction
        $connection = Helper::getInstance()->getSQL();
        $connection->executef("INSERT INTO " . DB_PREFIX . "COMMENT (MEDIA_ID, CONTENT, DATE, USER_ID)"
            . " VALUES(%d, '%s', FROM_UNIXTIME(%d), %d)", $this->mediaId, $this->content, $this->date, $this->userId);
        if ($connection->getUpdateCount() != 1) {
            throw new Exception("Database failure");
        }
        pb_Media::addComment($this->mediaId);
    }
    public static function createFromResultSet($rs) {
        $object = $rs->getRowObject();
        $comment = new pb_Comment($object->MEDIA_ID, $object->CONTENT, $object->DATE, $object->USER_ID);
        $comment->setId($object->ID);
        return $comment;
    }
    public static function getSelectionFields() {
        return 'ID, MEDIA_ID, CONTENT, ' . sql_Connection::toTimestamp('DATE') . ', USER_ID';
    }
    public static function initializeTable() {
        $connection = Helper::getInstance()->getSQL();
        $connection->execute('DROP TABLE IF EXISTS ' . DB_PREFIX . 'COMMENT');
        $connection->execute('CREATE TABLE ' . DB_PREFIX . 'COMMENT (' .
            'ID bigint(20) unsigned NOT NULL auto_increment,' .
            'MEDIA_ID bigint(20) unsigned NOT NULL,' .
            'CONTENT text NOT NULL default \'\', ' .
            'DATE datetime NOT NULL default \'0000-00-00 00:00:00\', ' .
            'USER_ID bigint(20) unsigned NOT NULL,' .
            'PRIMARY KEY (ID)' .
            ') CHARACTER SET utf8 COLLATE utf8_bin');
    }
}

function comment_add($exchange) {
    $request = $exchange->getRequest();
    $content = $request->getAttribute('content');
    $mediaId = $request->getAttribute('mediaId');
    $authUser = $exchange->getServer()->getContextKey('user');
    $date = time();
    $userId = $authUser->getId();
    $comment = new pb_Comment($mediaId, $content, $date, $authUser->getId());
    $comment->insert();
    $exchange->done("Comment inserted");
}

function comment_list($exchange) {
    $request = $exchange->getRequest();
    $mediaId = $request->getAttribute('mediaId');
    $connection = Helper::getInstance()->getSQL();
    $connection->executef('SELECT ' . pb_Comment::getSelectionFields() . ' FROM ' . DB_PREFIX .
        'COMMENT WHERE MEDIA_ID = %d', $mediaId);
    $response = $exchange->createResponseElement('commentListResult');
    $rs = $connection->getResultSet();
    while ($rs->next()) {
        $comment = pb_Comment::createFromResultSet($rs);
        $response->appendChild($exchange->createResponseElement('comment', array(
            'id' => $comment->getId(),
            'mediaId' => $comment->getMediaId(),
            'content' => $comment->getContent(),
            'date' => $comment->getDate(),
            'userId' => $comment->getUserId()
        )));
    }
    $exchange->replyXML($response);
}

function comment_listMedias($exchange) {
    $request = $exchange->getRequest();
    $from = sxe_Server::getDOMElementAttribute($request, 'from', 0);
    $limit = sxe_Server::getDOMElementAttribute($request, 'limit', 100);
    $connection = Helper::getInstance()->getSQL();
    $connection->executef('SELECT MEDIA_ID, ' . sql_Connection::toTimestamp('MAX(DATE)', 'MAX_DATE') . ' FROM ' . DB_PREFIX .
        'COMMENT WHERE DATE >= ' . sql_Connection::fromTimestamp('%d') . ' GROUP BY MEDIA_ID ORDER BY DATE DESC LIMIT %d', $from, $limit);
    $response = $exchange->createResponseElement('commentListResult');
    $rs = $connection->getResultSet();
    while ($rs->next()) {
        $comment = $rs->getRowObject();
        $response->appendChild($exchange->createResponseElement('comment', array(
            'mediaId' => $comment->MEDIA_ID,
            'lastDate' => $comment->MAX_DATE
        )));
    }
    $exchange->replyXML($response);
}

?>