<?php

require_once('util.php');

class pb_Media {
    public static $TYPE_PICTURE = 0;
    public static $TYPE_MOVIE = 1;
    public static $TYPE_TEXT = 2;

    protected $id;
    protected $type = 0;
    protected $filename = NULL;
    protected $date = NULL;
    protected $userId = 0;
    protected $description = NULL;
    protected $publicationDate = NULL;
    protected $commentCount = 0;
	/*
	 * Missing information:
	 * when: date
	 * where: latitude, longitude, altitude
	 * who: people
	 */
    /*
     * See http://en.wikipedia.org/wiki/Geotagging
     * Decimal degrees with negative numbers for South and West.
     * 41.89028; 12.49248
     */

    public function __construct($type, $filename, $date, $userId, $description = NULL, $publicationDate = NULL, $commentCount = 0) {
        $this->id = -1;
        $this->type = $type;
        $this->filename = $filename;
        $this->date = $date;
        $this->userId = $userId;
        $this->commentCount = $commentCount;
        if ($description != NULL) {
            $this->description = $description;
        } else {
            $this->description = '';
        }
        if ($publicationDate != NULL) {
            $this->publicationDate = $publicationDate;
        } else {
            $this->publicationDate = time();
        }
    }
	public function getId() {
        return $this->id;
    }
	public function setId($id) {
        $this->id = $id;
    }
	public function getType() {
        return $this->type;
    }
	public function setType($type) {
        $this->type = $type;
    }
	public function getFilename() {
        return $this->filename;
    }
	public function setFilename($filename) {
        $this->filename = $filename;
    }
	public function getDate() {
        return $this->date;
    }
	public function setDate($date) {
        $this->date = $date;
    }
	public function getUserId() {
        return $this->userId;
    }
	public function setUserId($userId) {
        $this->userId = $userId;
    }
	public function getDescription() {
        return $this->description;
    }
	public function setDescription($description) {
        $this->description = $description;
    }
	public function getPublicationDate() {
        return $this->publicationDate;
    }
	public function setPublicationDate($publicationDate) {
        $this->publicationDate = $publicationDate;
    }
	public function getCommentCount() {
        return $this->commentCount;
    }
	public function setCommentCount($commentCount) {
        $this->commentCount = $commentCount;
    }
	public function getFolder() {
        return PRIVATE_PATH . '/' . sprintf('%04d', $this->getUserId()) . '/' . date('Y', $this->getDate());
    }
	public function getExtension() {
	   if ($this->type == pb_Media::$TYPE_PICTURE) {
	       return '.jpg';
	   } else if ($this->type == pb_Media::$TYPE_MOVIE) {
           return '.flv';
       } else if ($this->type == pb_Media::$TYPE_TEXT) {
           return '.txt';
       }
       return '';
    }
	public function insert() {
        $connection = Helper::getInstance()->getSQL();
        $connection->executef('INSERT INTO ' . DB_PREFIX . 'MEDIA (ID, TYPE, FILENAME, DATE, USER_ID, DESCRIPTION, PUBLICATION_DATE, COMMENT_COUNT)'
            . ' VALUES(%d, %d, \'%s\', ' . sql_Connection::fromTimestamp('%d') . ', \'%s\', \'%s\', ' . sql_Connection::fromTimestamp('%d') . ', %d)',
            $this->getId(), $this->type, $this->filename, $this->date, $this->userId, $this->description, $this->publicationDate, $this->commentCount);
        if ($connection->getUpdateCount() != 1) {
            throw new Exception("Database failure");
        }
    }
	public function store($upfile, $upmini = NULL) {
        $mediafolder = PB_PATH . $this->getFolder();
        //$filename = Helper::toFilename(utf8_decode($this->getFilename()));
        if (! Helper::mkdir($mediafolder)) {
            throw new Exception("Cannot create the media directory");
        }
        $upfile->moveTo($mediafolder . '/' . $this->getId() . $this->getExtension());
        if ($upmini != NULL) {
            if (! Helper::mkdir($mediafolder . '/mini', 0777)) {
                throw new Exception("Cannot create the media directory");
            }
            $upmini->moveTo($mediafolder . '/mini/' . $this->getId() . '.jpg');
        }
    }
    public static function newId() {
        $connection = Helper::getInstance()->getSQL();
        if (! $connection->isInTransaction()) {
            throw new Exception("No transaction available");
        }
        $connection->executef('SELECT ID FROM ' . DB_PREFIX . 'MEDIA_ID');
        $rs = $connection->getResultSet();
        if (! $rs->next()) {
            throw new Exception("Database failure");
        }
        $object = $rs->getRowObject();
        $connection->executef('UPDATE ' . DB_PREFIX . 'MEDIA_ID SET ID=ID+1');
        if ($connection->getUpdateCount() != 1) {
            throw new Exception("Database failure");
        }
        return $object->ID;
    }
    public static function addComment($id) {
        $connection = Helper::getInstance()->getSQL();
        $connection->executef('UPDATE ' . DB_PREFIX . 'MEDIA SET COMMENT_COUNT=COMMENT_COUNT+1 WHERE ID=%d', $id);
        if ($connection->getUpdateCount() != 1) {
            throw new Exception("Database failure");
        }
    }
    public static function createFromResultSet($rs) {
        $object = $rs->getRowObject();
        $media = new pb_Media($object->TYPE, $object->FILENAME, $object->DATE, $object->USER_ID,
        	$object->DESCRIPTION, $object->PUBLICATION_DATE, $object->COMMENT_COUNT);
        $media->setId($object->ID);
        return $media;
    }
    public static function getSelectionFields() {
        return 'ID, TYPE, FILENAME, ' . sql_Connection::toTimestamp('DATE') . ', USER_ID, DESCRIPTION, ' .
        	sql_Connection::toTimestamp('PUBLICATION_DATE') . ', COMMENT_COUNT';
    }
    public static function getLastPublicationDate() {
        $connection = Helper::getInstance()->getSQL();
        $connection->executef('SELECT ' . sql_Connection::toTimestamp('MAX(PUBLICATION_DATE)', 'MAX_DATE') . ' FROM ' . DB_PREFIX . 'MEDIA');
        $rs = $connection->getResultSet();
        if (! $rs->next()) {
            return NULL;
        }
        $object = $rs->getRowObject();
        return $object->MAX_DATE;
    }
    public static function initializeTable() {
        $connection = Helper::getInstance()->getSQL();
        $connection->execute('DROP TABLE IF EXISTS ' . DB_PREFIX . 'MEDIA_ID');
        $connection->execute('CREATE TABLE ' . DB_PREFIX . 'MEDIA_ID (ID bigint(20) unsigned NOT NULL default \'0\')');
        $connection->execute('INSERT INTO ' . DB_PREFIX . 'MEDIA_ID (ID) VALUES(1)');
        $connection->execute('DROP TABLE IF EXISTS ' . DB_PREFIX . 'MEDIA');
        $connection->execute('CREATE TABLE ' . DB_PREFIX . 'MEDIA (' .
            'ID bigint(20) unsigned NOT NULL default \'0\', ' .
            'TYPE int(3) NOT NULL default \'0\', ' .
            'FILENAME varchar(256) NOT NULL default \'\', ' .
            'DATE datetime NOT NULL default \'0000-00-00 00:00:00\', ' .
            'USER_ID bigint(20) unsigned NOT NULL, ' .
            'DESCRIPTION varchar(1024) NOT NULL default \'\', ' .
            'PUBLICATION_DATE datetime NOT NULL default \'0000-00-00 00:00:00\', ' .
            //'PEOPLE varchar(256) NOT NULL default \'\', ' .
            //'LOCATION varchar(32) NOT NULL default \'\', ' .
            'COMMENT_COUNT int(11) NOT NULL default \'0\', ' .
            'PRIMARY KEY (ID)' .
        ') CHARACTER SET utf8 COLLATE utf8_bin');
    }
    public static function initialize() {
        pb_Media::initializeTable();
        //Helper::cleandir(PB_PRIVATE_PATH);
        if (! Helper::mkdir(PB_PRIVATE_PATH . '/misc')) {
            throw new Exception("Cannot create the misc directory");
        }
    }
}
function media_add($exchange) {
    $request = $exchange->getRequest();
    $date = $request->getAttribute('date'); // as unix timestamp
    $description = $request->getAttribute('description');
    $type = sxe_Server::getDOMElementAttribute($request, 'type', pb_Media::$TYPE_PICTURE);
    $name = sxe_Server::getDOMElementAttribute($request, 'name', NULL);
    $miniKey = sxe_Server::getDOMElementAttribute($request, 'miniKey', 'mini');
    $localFile = sxe_Server::getDOMElementAttribute($request, 'localFile', NULL);
    $authUser = $exchange->getServer()->getContextKey('user');
    $publicationDate = time();
    $userId = $authUser->getId();
    if ($localFile == NULL) {
        $fileKey = sxe_Server::getDOMElementAttribute($request, 'fileKey', 'file');
        $file = util_UploadedFile::createFromDistant($fileKey, $name);
    } else {
        $file = util_UploadedFile::createFromLocal($localFile, $name);
    }
    $mini = util_UploadedFile::createFromDistant($miniKey);
    $media = new pb_Media($type, $file->getName(), $date, $authUser->getId(), $description, $publicationDate);
    $connection = Helper::getInstance()->getSQL();
    $connection->begin();
    try {
        $media->setId(pb_Media::newId());
        $media->store($file, $mini);
        $media->insert();
        $connection->commit();
        $exchange->done('Media inserted');
    }
    catch(Exception $e) {
        $connection->rollback();
        throw $e;
    }
}

function media_list($exchange) {
    $request = $exchange->getRequest();
    $from = sxe_Server::getDOMElementAttribute($request, 'from', 0);
    $to = sxe_Server::getDOMElementAttribute($request, 'to', time() + 1);
    $connection = Helper::getInstance()->getSQL();
    $connection->executef('SELECT ' . pb_Media::getSelectionFields() . ' FROM ' . DB_PREFIX .
        'MEDIA WHERE PUBLICATION_DATE >= ' . sql_Connection::fromTimestamp('%d') .
        'AND PUBLICATION_DATE < ' . sql_Connection::fromTimestamp('%d'),
        $from, $to);
    $response = $exchange->createResponseElement('mediaListResult');
    $rs = $connection->getResultSet();
    while ($rs->next()) {
        $media = pb_Media::createFromResultSet($rs);
        $response->appendChild($exchange->createResponseElement('media', array(
            'id' => $media->getId(),
            'type' => $media->getType(),
            'filename' => $media->getFilename(),
            'date' => $media->getDate(),
            'userId' => $media->getUserId(),
            'description' => $media->getDescription(),
            'pubDate' => $media->getPublicationDate(),
            'commentCount' => $media->getCommentCount()
        )));
    }
    $exchange->replyXML($response);
}

?>