define(['jls/lang/Class', 'jls/html/HtmlElement'], function (Class, HtmlElement) {

var GuiUtilities;
/**
 * @namespace Provides GUI classes for HTML.
 * @name jls.html
 */

GuiUtilities = Class.create();

Object.extend(GuiUtilities, /** @lends jls.html.GuiUtilities */
{
    getRoot : function() {
        return GuiUtilities.BodyElement.getInstance();
    },
    invokeAndWait : function(fn) {
        return fn();
    },
    invokeLater : function(fn) {
    	setTimeout(fn, 10);
    }
});

GuiUtilities.BodyElement = Class.create(HtmlElement,
{
    getTitle : function() {
        return window.document.title;
    },
    setTitle : function(value) {
        window.document.title = this.getResourceLabel(value);
        return this;
    }
});

Object.extend(GuiUtilities.BodyElement,
{
    _instance : null,
    getInstance : function() {
        if (GuiUtilities.BodyElement._instance == null) {
            var body = document.getElementsByTagName('body')[0];
            GuiUtilities.BodyElement._instance = new GuiUtilities.BodyElement({attributes: {htmlElement: body}});
        }
        return GuiUtilities.BodyElement._instance;
    }
});

return GuiUtilities;
});
