define(['jls/lang/Class', 'jls/gui/Element', 'jls/html/DomEvent'], function (Class, Element, DomEvent) {

var HtmlElement;
HtmlElement = Class.create(Element,
{
    /*initialize : function($super, parameters, parent) {
        $super(parameters, parent);
    },*/
    onCreate : function() {
    	this._htmlElement = this.getAttribute('htmlElement');
    	if (this._htmlElement == null) {
    		this._htmlElement = this.onCreateHtmlElement();
    	}
    },
    onCreateHtmlElement : function() {
        return document.createElement(this.getAttribute('htmlTagName') || 'div');
    },
    getHtmlElement : function() {
    	return this._htmlElement;
    },
    onAddChild : function(child) {
    	if (child instanceof HtmlElement) {
    		this._htmlElement.appendChild(child._htmlElement);
    	}
    },
    getTextContent : function() {
        if ((this._htmlElement != null) && (this._htmlElement.firstChild.nodeType == 3)) {
            return this._htmlElement.firstChild.nodeValue;
        }
        return '';
    },
    setClass : function(value) {
        this._htmlElement.className = value;
        return this;
    },
    getClass : function() {
        return this._htmlElement.className;
    },
    clean : function() {
        while (this._htmlElement.hasChildNodes()) {
            this._htmlElement.removeChild(this._htmlElement.firstChild);
        }
        return this;
    },
    setTextContent : function(value) {
        this.clean();
    	this._htmlElement.appendChild(document.createTextNode(this.getResourceLabel(value)));
        return this;
    },
    setHtmlContent : function(value) {
        this.clean();
        this._htmlElement.innerHTML = value;
        return this;
    },
    onSetAttribute : function(key, value) {
    	if ((typeof value != 'undefined') && (value != null)) {
        	this._htmlElement.setAttribute(key, value);
    	} else {
            this._htmlElement.removeAttribute(key);
    	}
    },
    onGetAttribute : function(key) {
        return this._htmlElement.getAttribute(key);
    },
    onStyleChange : function(key, oldValue, newValue) {
    	//jls.logger.trace('onStyleChange(' + key + ', ' + oldValue + ', ' + newValue + ')');
        if (this._htmlElement == null) {
            return;
        }
        if (newValue != null) {
            this._htmlElement.style[key] = newValue;
            //this._htmlElement.style.setProperty(key, newValue);
        } else {
            this._htmlElement.style.removeProperty(key);
        }
    },
    observe: function($super, type, handler) {
	    $super(type, handler);
	    HtmlElement.addEventListener(this._htmlElement, type, (function(e) {
            this.dispatch(new DomEvent(e, this));
        }).bind(this));
    },
    unobserve: function($super, type, handler) {
    	$super(type, handler);
    	this._htmlElement.removeEventListener(type, handler, false);
    	// TODO
    },
    onDestroy : function(detach) {
        //jls.logger.trace('onDestroy() ' + this._htmlElement.nodeName);
        if ((! detach) && this._htmlElement) {
            if (this._htmlElement.parentNode) {
                this._htmlElement.parentNode.removeChild(this._htmlElement);
            }
        }
    }
});

Object.extend(HtmlElement,
{
    addEventListener : function(element, type, handler) {
        if (element.addEventListener) {
            element.addEventListener(type, handler, false);
        } else {
            element.attachEvent('on' + type, handler, false);
        }
    }
});


return HtmlElement;
});
