define(['jls/lang/Class', 'jls/lang/Logger', 'jls/html/HtmlElement'], function (Class, Logger, HtmlElement) {

var Table;
Table = Class.create(HtmlElement,
{
    initialize : function($super, parameters, parent) {
        this._fixedOrientation = 'horizontal';
        this._fixedSize = 1;
        this._tableBody = null;
        this._cellAttributes = null;
        this._rowAttributes = null;
        this._cellStyle = null;
        $super(parameters, parent);
    },
    onCreate : function($super) {
        this.setAttribute('htmlTagName', 'table');
        $super();
        this._tableBody = document.createElement('tbody');
        this.getHtmlElement().appendChild(this._tableBody);
    },
    setCellAttributes : function(cellAttributes) {
        this._cellAttributes = cellAttributes;
        return this;
    },
    setRowAttributes : function(rowAttributes) {
        this._rowAttributes = rowAttributes;
        return this;
    },
    setCellStyle : function(cellStyle) {
        this._cellStyle = cellStyle;
        return this;
    },
    getFixedOrientation : function() {
        return this._fixedOrientation;
    },
    setFixedOrientation : function(value) {
        this._fixedOrientation = value;
        return this;
    },
    getFixedSize : function() {
        return this._fixedSize;
    },
    setFixedSize : function(value) {
        if (typeof value != 'number') {
            value = parseInt(value, 10);
        }
        this._fixedSize = value;
        return this;
    },
    addRow : function() {
        Logger.getInstance().trace('addRow()');
        var row = document.createElement('tr');
        if (this._rowAttributes != null) {
            for (var name in this._rowAttributes) {
                row.setAttribute(name, this._rowAttributes[name]);
            }
        }
        this._tableBody.appendChild(row);
        return row;
    },
    onAddChild : function(child) {
        var cell = document.createElement('td');
        if (this._cellAttributes != null) {
            for (var name in this._cellAttributes) {
                switch (name) {
                case 'class':
                case 'className':
                    cell.className = this._cellAttributes[name];
                    break;
                default:
                    cell.setAttribute(name, this._cellAttributes[name]);
                    break;
                }
            }
        }
        if (this._cellStyle != null) {
            for (var key in this._cellStyle) {
                cell.style[key] = this._cellStyle[key];
            }
        }
        var cellIndex = (this.getChildCount() - 1) % this._fixedSize;
        Logger.getInstance().trace('onAddChild() cellIndex: ' + cellIndex);
        var row = null;
        if (this._fixedOrientation == 'horizontal') {
            if (cellIndex == 0) {
                row = this.addRow('tr');
            } else {
                row = this._tableBody.lastChild;
            }
        } else {
            if (this.getChildCount() <= this._fixedSize) {
                row = this.addRow('tr');
            } else {
                row = this._tableBody.childNodes[cellIndex];
            }
        }
        row.appendChild(cell);
        cell.appendChild(child.getHtmlElement());
    }
});

return Table;
});
