define(['jls/lang/Class'], function (Class) {

var Location;
/**
 * @class This class is a collection of Location helper functions.
 */
Location = Class.create();

Object.extend(Location, /** @lends jls.util.Location */
{
	hash : function(value) {
		if (typeof value == 'undefined') {
	        return this.getHash();
		}
		this.setHash(value);
	},
	search : function(value) {
		if (typeof value == 'undefined') {
	        return this.getSearch();
		}
		this.setSearch(value);
	},
    reload : function() {
        window.location.reload();
        return this;
    },
	getHash : function() {
		var hash = window.location.hash;
        return hash && hash.length > 1 ? hash.substr(1) : '';
	},
	setHash : function(value) {
		if (value) {
			window.location.replace(window.location.pathname + '#' + value);
		} else {
			window.location.replace(window.location.pathname + '#');
		}
	},
	getSearch : function() {
		var search = window.location.search;
        return search && search.length > 1 ? search.substr(1) : '';
	},
	setSearch : function(value) {
		if (value) {
			window.location.search = value;
		} else {
			window.location.replace(window.location.pathname);
		}
	},
    toQuery : function(queryObj) {
    	var queryStr = '';
    	for (var key in queryObj) {
    		if (queryStr.length > 0) {
        		queryStr += '&';
    		}
    		queryStr += key + '=' + queryObj[key];
    	}
    	return queryStr;
    },
    decodeURIComponent : function(s) {
        return decodeURIComponent(s).replace('+', ' ');
	},
    parseQuery : function(queryStr) {
        var queryObj = null;
        var pairs = queryStr.split('&');
        for (var i = 0; i < pairs.length; i++) {
        	var pair = pairs[i];
        	var j = pair.indexOf('=');
        	if (j >= 0) {
        	    if (queryObj == null) {
        	        queryObj = {};
        	    }
                var key = Location.decodeURIComponent(pair.substring(0, j));
                var value = Location.decodeURIComponent(pair.substring(j + 1));
        		queryObj[key] = value;
        	}
        }
        return queryObj;
    }
});

return Location;
});
