define(['jls/lang/Class', 'jls/html/HtmlElement'], function (Class, HtmlElement) {

var GroupPreview;
GroupPreview = Class.create(HtmlElement,
{
    initialize : function($super, parameters, parent) {
        this._content = null;
        this._label = null;
        this._group = 'group' in parameters ? parameters.group : null;
        $super(parameters, parent);
        
        var media = this._group.getPreviewMedia();
        media.createMiniature({media: media, attributes: {'class': 'media'}}, this);
        while (this._label.hasChildNodes()) {
            this._label.removeChild(this._label.firstChild);
        }
        this._label.appendChild(document.createTextNode(this._group.getName()));
    },
    onCreate : function($super) {
        this.setAttribute('htmlTagName', 'table');
        $super();
        var tbody = document.createElement('tbody');
        var contentRow = document.createElement('tr');
        this._content = document.createElement('td');
        this._content.className = 'preview';
        var titleRow = document.createElement('tr');
        var titleCell = document.createElement('td');
        titleCell.className = 'titled_preview';
        this._label = document.createElement('label');
        this.getHtmlElement().appendChild(tbody);
        tbody.appendChild(contentRow);
        contentRow.appendChild(this._content);
        tbody.appendChild(titleRow);
        titleRow.appendChild(titleCell);
        titleCell.appendChild(this._label);
    },
    onAddChild : function(child) {
        this._content.appendChild(child._htmlElement);
    },
    getGroup : function() {
        return this._group;
    }
});


return GroupPreview;
});
