define(['jls/lang/Class', 'jls/html/HtmlElement'], function (Class, HtmlElement) {

var Icon;
Icon = Class.create(HtmlElement,
{
    initialize : function($super, parameters, parent) {
        this._img = null;
        $super(parameters, parent);
    },
    onCreate : function($super) {
        this.setAttribute('htmlTagName', 'div');
        $super();
        this.setAttribute('class', 'icon');
        this._img = document.createElement('img');
        this.getHtmlElement().appendChild(this._img);
    },
    setIconSrc : function(value) {
        this._img.setAttribute('src', value);
    },
    setIconTitle : function(value) {
        this._img.setAttribute('title', this.getResourceLabel(value));
    }
});


return Icon;
});
