define(['jls/lang/Class', 'jls/lang/Logger','jls/html/HtmlElement', 'jls/gui/TemplateContainer'], function(Class, Logger, HtmlElement, TemplateContainer) {

    var MessageBox = Class.create(HtmlElement, {
        initialize : function($super, parameters, parent) {
            TemplateContainer.create(this, MessageBox.TEMPLATE, $super, parameters, parent);
        }
    });

    Object.extend(MessageBox, {
        TEMPLATE : {
            attributes : {
                htmlTagName : 'div',
                'class' : 'glassBg'
            },
            style : {
                position : 'absolute',
                textAlign : 'center',
                width : '100%',
                height : '100%',
                left : '0px',
                top : '0px'
            },
            children : [{
                classname : 'jls/html/HtmlElement',
                attributes : {
                    htmlTagName : 'div',
                    'class' : 'box',
                    id : 'container'
                },
                style : {
                    margin : '30px',
                    padding : '30px'
                }
            }]}
    });
    
    return TemplateContainer.prepareClass(MessageBox);
});
