define(['jls/lang/Class'], function (Class) {

var User;
User = Class.create(
{
    initialize : function(id, login, password, email, rights, creationDate, lastAuthenticationDate, alertThreshold) {
        this.id = id;
        this.login = login;
        this.password = password;
        this.email = email;
        this.creationDate = creationDate;
        this.lastAuthenticationDate = lastAuthenticationDate;
        this.alertThreshold = alertThreshold;
        rights = typeof rights == 'string' ? rights : '';
        var rightList = rights.split(',');
        this.rights = {};
        for (var i = 0; i < rightList.length; i++) {
            this.rights[rightList[i]] = true;
        }
    },
    toXML : function() {
    }
});

Object.extend(User,
{
    createFromXML : function(xmlUser) {
        return new User(
                parseInt(xmlUser.getAttribute('id'), 10),
                xmlUser.getAttribute('login'),
                xmlUser.getAttribute('password'),
                xmlUser.getAttribute('email'),
                xmlUser.getAttribute('rights'),
                new Date(parseInt(xmlUser.getAttribute('creationDate'), 10) * 1000),
                new Date(parseInt(xmlUser.getAttribute('lastAuthenticationDate'), 10) * 1000),
                xmlUser.getAttribute('alertThreshold')
                );
    }
});


return User;
});
