<?php
//error_reporting(0); // Turn off all error reporting

require_once('util.php');
require_once('user.php');
require_once('repository.php');
require_once('media.php');
require_once('comment.php');
require_once('init.php');

function default_initialize($exchange) {
    $connection = Helper::getInstance()->getSQL();
    $connection->executef('SHOW TABLES FROM %s LIKE \'%sUSER\'', DB_NAME, DB_PREFIX);
    $rs = $connection->getResultSet();
    $rs->setFetchAsObject(FALSE);
    $tableUserExists = FALSE;
    if ($rs->next()) {
        $row = $rs->getRowObject();
        $tableUserExists = ($row[0] == (DB_PREFIX . 'USER'));
    }
    if ($tableUserExists) {
        $user = util_RightHandler::getContextUser($exchange->getServer());
        if (! $user->hasRight('admin')) {
            throw new Exception('Required right not found');
        }
    }
    Helper::rmdir(PB_REPOSITORY_PATH);
    init_initialize(NULL);
    $exchange->done('Photo Blog initialized');
}

$connectRightAttributes = array('requiredRight' => 'connect');
$adminRightAttributes = array('requiredRight' => 'admin');
$repositoryRightAttributes = array('requiredRight' => 'repository');

$writeRepositoryRightAttributes = array('requiredRepositoryRight' => 'write', 'repositoryIdAttName' => 'repositoryId', 'requiredRight' => 'connect');
$connectMediaRightAttributes = array('requiredRepositoryRight' => 'connect', 'mediaIdAttName' => 'mediaId', 'requiredRight' => 'connect');
$adminMediaRightAttributes = array('requiredRepositoryRight' => 'admin', 'mediaIdAttName' => 'mediaId', 'requiredRight' => 'connect');
$commentMediaRightAttributes = array('requiredRepositoryRight' => 'comment', 'mediaIdAttName' => 'mediaId', 'requiredRight' => 'connect');

$server = Helper::getInstance()->getServer();

$server->registerOperation('default_initialize', 'initialize');

$server->registerOperation('user_create', 'createUser');
$server->registerOperation('user_activate', 'activateUser');
$server->registerOperation('user_authorize', 'authorizeUser', $adminRightAttributes);
$server->registerOperation('user_lostPassword', 'lostUserPassword');
$server->registerOperation('user_changePassword', 'changeUserPassword');
$server->registerOperation('user_modify', 'modifyUser', $connectRightAttributes);
$server->registerOperation('user_list', 'listUsers', $connectRightAttributes);
$server->registerOperation('user_get', 'getUser', $connectRightAttributes);
$server->registerOperation('user_authenticate', 'authenticateUser', $connectRightAttributes);
$server->registerOperation('user_delete', 'deleteUser', $adminRightAttributes);
$server->registerOperation('user_sendMail', 'sendMail', $adminRightAttributes);
$server->registerOperation('user_feed', 'feedUser', $adminRightAttributes);

$server->registerOperation('media_add', 'addMedia', $writeRepositoryRightAttributes);
$server->registerOperation('media_list', 'listMedias', $connectRightAttributes);
$server->registerOperation('media_listPublic', 'listPublicMedias');
$server->registerOperation('media_delete', 'deleteMedia', $adminMediaRightAttributes);

$server->registerOperation('comment_add', 'addComment', $commentMediaRightAttributes);
$server->registerOperation('comment_list', 'listComment', $connectMediaRightAttributes);
$server->registerOperation('comment_modify', 'modifyComment', $connectRightAttributes);
$server->registerOperation('comment_delete', 'deleteComment', $connectRightAttributes);
$server->registerOperation('comment_listMedias', 'listCommentedMedias', $connectRightAttributes);

$server->registerOperation('repository_create', 'createRepository', $repositoryRightAttributes);
$server->registerOperation('repository_delete', 'deleteRepository', $repositoryRightAttributes);
$server->registerOperation('repository_modify', 'modifyRepository', $repositoryRightAttributes);
$server->registerOperation('repository_list', 'listRepository', $connectRightAttributes);
$server->registerOperation('repository_listPublic', 'listPublicRepository');
$server->registerOperation('repository_addUser', 'addRepositoryUser', $connectRightAttributes);
$server->registerOperation('repository_removeUser', 'removeRepositoryUser', $connectRightAttributes);
$server->registerOperation('repository_modifyUser', 'modifyRepositoryUser', $connectRightAttributes);

$server->process();

?>