<?php
//error_reporting(0); // Turn off all error reporting
require_once('util.php');
require_once('user.php');
require_once('media.php');
require_once('comment.php');
require_once('repository.php');

function init_initialize($adminPassword = NULL) {
    if ($adminPassword == NULL) {
        $adminPassword = 'changeit';
    }
    Helper::mkdir(PB_INCOMING_PATH);

    Helper::mkdir(PB_REPOSITORY_PATH);
    // generate the .htaccess
    $file = fopen(PB_REPOSITORY_PATH . '/.htaccess', 'w');
    fwrite($file, sprintf(HTACCESS_FORMAT, SITE_PATH . REPOSITORY_PATH . '/' . USER_HTPASSWD_FILE));
    fclose($file);
    // generate the access dummy file
    $file = fopen(PB_REPOSITORY_PATH . '/' . PRIVATE_ACCESS_FILE, 'w');
    fwrite($file, "<access><ok /></access>\n");
    fclose($file);
    
    pb_User::initializeTable();
    pb_Media::initializeTable();
    pb_Comment::initializeTable();
    pb_Repository::initializeTable();

    $adminUser = new pb_User(ADMIN_LOGIN, sha1($adminPassword), Helper::getInstance()->getAdminEMail(), 'read,repository,admin', time(), '');
    $adminUser->insert();
    $guestUser = new pb_User('guest', sha1('guest'), 'guest@none', 'read', time(), '');
    $guestUser->insert();
    
    pb_User::generateGlobalHtpasswd();
    
    $publicRepository = new pb_Repository($adminUser->getId(), 'Public', 'Default public repository', FALSE, TRUE);
    $publicRepository->create();
    $publicRepository->addUser($guestUser->getId(), 'read,comment');

    $repository = new pb_Repository($adminUser->getId(), 'Members', 'Default members repository', TRUE, TRUE);
    $repository->create();
    $repository->addUser($guestUser->getId(), 'read,comment');
}

?>
