define('jls/gui/Layout', ['jls/lang/Class'], function (Class) {

var Layout;
/*
The WPF layout engine uses a recursive two-phase system.
* First is the measure phase, where every element in the UI tree is queried for its desired size.
* Second is the arrange phase, where each element is instructed as to its actual size and location.
WPF ships with a handful of layout panels (StackPanel, WrapPanel, Canvas, UniformGrid, Grid, DockPanel) with each panel specializing in a particular type of layout.
*/
Layout = Class.create( /** @lends jls.gui.Layout.prototype */
{
    /**
     * Creates an layout.
     * 
     * @param {jls.gui.Panel} element The panel element.
     * @constructs
     * @see jls.gui.BorderLayout
     * @see jls.gui.CardLayout
     * @see jls.gui.FlowLayout
	 * @class Provides basic layout for Panel.
     */
    initialize : function(element) {
    	this._element = null;
    	this.setElement(element);
    },
    getElement : function() {
    	return this._element;
    },
    setElement : function(element) {
    	this._element = element;
    },
    onAddChild : function(child) {
        this._element.update();
    },
    onRemoveChild : function(child) {
        this._element.update();
    },
    // TODO onLayout ?
    onUpdate : Class.emptyFunction,
    onCreate : Class.emptyFunction
});

return Layout;
});
