define('jls/html/CheckBox', ['jls/lang/Class', 'jls/html/HtmlElement'], function (Class, HtmlElement) {
    // CheckBox
    return Class.create(HtmlElement,
    {
        onCreate : function($super) {
            this.setAttribute('htmlTagName', 'input');
            $super();
            this.getHtmlElement().setAttribute('type', 'checkbox');
        },
        getChecked : function() {
            return this.getHtmlElement().checked;
        },
        isChecked : function() {
            return this.getChecked();
        },
        setChecked : function(value) {
            this.getHtmlElement().checked = value;
            return this;
        }/*,
        getChecked : function() {
            return this.getHtmlElement().getAttribute('checked') == 'checked';
        },
        isChecked : function() {
            return this.getChecked();
        },
        setChecked : function(value) {
            if (value) {
                this.getHtmlElement().setAttribute('checked', 'checked');
            } else {
                this.getHtmlElement().removeAttribute('checked');
            }
            return this;
        }*/,
        getDisabled : function() {
            return this.getHtmlElement().getAttribute('disabled') == 'disabled';
        },
        isDisabled : function() {
            return this.getDisabled();
        },
        setDisabled : function(value) {
            if (value) {
                this.getHtmlElement().setAttribute('disabled', 'disabled');
            } else {
                this.getHtmlElement().removeAttribute('disabled');
            }
            return this;
        },
        getReadonly : function() {
            return this.getHtmlElement().getAttribute('readonly') == 'readonly';
        },
        isReadonly : function() {
            return this.getReadonly();
        },
        setReadonly : function(value) {
            if (value) {
                this.getHtmlElement().setAttribute('readonly', 'readonly');
            } else {
                this.getHtmlElement().removeAttribute('readonly');
            }
            return this;
        }
    });
});
