define('jls/html/ComboBox', ['jls/lang/Class', 'jls/lang/Logger', 'jls/html/HtmlElement'], function (Class, Logger, HtmlElement) {
    return Class.create(HtmlElement,
    {
        onCreate : function($super) {
            this.setAttribute('htmlTagName', 'select')
            $super();
        },
        addString : function(value) {
            var option = document.createElement('option');
            option.appendChild(document.createTextNode(this.getResourceLabel(value)));
            this.getHtmlElement().appendChild(option);
            //parseInt( select.options[ select.options.selectedIndex ].value );
        },
        getCurrentSelectionIndex : function() {
            return this.getHtmlElement().options.selectedIndex;
        },
        setCurrentSelectionIndex : function(index) {
            this.getHtmlElement().options.selectedIndex = index;
            return this;
        },
        getCurrentSelectionText : function() {
            var index = this.getCurrentSelectionIndex();
            Logger.getInstance().trace('getCurrentSelectionText() [' + index + ']');
            return this.getHtmlElement().options[index].value;
        },
        getText : function() {
            return '';//this.getTextContent();
        },
        setText : function(value) {
            //this.setTextContent(value);
            return this;
        }
    });
});
