define('jls/html/DomEvent', ['jls/lang/Class', 'jls/gui/Event'], function (Class, Event) {

var DomEvent;
/**
 * @class This class represents a DOM event.
 * @name jls.html.DomEvent
 */
DomEvent = Class.create(Event, /** @lends jls.html.DomEvent.prototype */
{
    initialize : function(event, element) {
        this.type = event.type;
        this.target = event.target;
        this.timeStamp = event.timeStamp;
        this.element = element;
        this._event = event;
    },
    keyCode : function() {
        return ('which' in this._event) ? this._event.which : this._event.keyCode;
    }
});

if (window.attachEvent) { // IE specific event handling
	DomEvent.addMethods({
	    stopPropagation : function() {
        	this._event.cancelBubble = true;
	    },
	    preventDefault : function() {
	    	this._event.returnValue = false;
	    }
	});
} else {
	DomEvent.addMethods({
	    stopPropagation : function() {
        	this._event.stopPropagation();
	    },
	    preventDefault : function() {
        	this._event.preventDefault();
	    }
	});
}

return DomEvent;
});
