define('jls/html/Table', ['jls/lang/Class', 'jls/lang/Exception', 'jls/lang/Logger', 'jls/html/HtmlElement'], function (Class, Exception, Logger, HtmlElement) {

var Table;
Table = Class.create(HtmlElement,
{
    initialize : function($super, parameters, parent) {
        this._fixedOrientation = 'horizontal';
        this._fixedSize = 1;
        this._tableBody = null;
        this._rowAttributes = null;
        this._cellAttributes = null;
        this._cellStyle = null;
        $super(parameters, parent);
    },
    onCreate : function($super) {
        this.setAttribute('htmlTagName', 'table');
        $super();
        this._tableBody = document.createElement('tbody');
        this.getHtmlElement().appendChild(this._tableBody);
    },
    setCellAttributes : function(cellAttributes) {
        this._cellAttributes = cellAttributes;
        return this;
    },
    setRowAttributes : function(rowAttributes) {
        this._rowAttributes = rowAttributes;
        return this;
    },
    setCellStyle : function(cellStyle) {
        this._cellStyle = cellStyle;
        return this;
    },
    getFixedOrientation : function() {
        return this._fixedOrientation;
    },
    setFixedOrientation : function(value) {
        this._fixedOrientation = value;
        return this;
    },
    getFixedSize : function() {
        return this._fixedSize;
    },
    setFixedSize : function(value) {
        if (typeof value != 'number') {
            value = parseInt(value, 10);
        }
        this._fixedSize = value;
        return this;
    },
    insertRow : function(num) {
        Logger.getInstance().trace('insertRow(' + num + ')');
        var row = document.createElement('tr');
        if (this._rowAttributes != null) {
            for (var name in this._rowAttributes) {
                row.setAttribute(name, this._rowAttributes[name]);
            }
        }
        var refElement = null;
        if (num && (num >= 0) && (num < this._tableBody.childNodes.length)) {
            refElement = this._tableBody.childNodes[num];
        }
        this._tableBody.insertBefore(row, refElement);
        return row;
    },
    addRow : function() {
        Logger.getInstance().trace('addRow()');
        return this.insertRow();
    },
    getRow : function(num) {
        Logger.getInstance().trace('getRow(' + num + ')');
        if (typeof num == 'number') {
            if ((num >= 0) && (num < this._tableBody.childNodes.length)) {
                return this._tableBody.childNodes[num];
            }
            while (num > this._tableBody.childNodes.length) {
                this.addRow();
            }
        }
        return this.addRow();
    },
    addCell : function(row, child) {
        Logger.getInstance().trace('addCell()');
        var cell = document.createElement('td');
        if (this._cellAttributes != null) {
            for (var name in this._cellAttributes) {
                switch (name) {
                case 'class':
                case 'className':
                    cell.className = this._cellAttributes[name];
                    break;
                default:
                    cell.setAttribute(name, this._cellAttributes[name]);
                    break;
                }
            }
        }
        if (this._cellStyle != null) {
            for (var key in this._cellStyle) {
                cell.style[key] = this._cellStyle[key];
            }
        }
        row.appendChild(cell);
        cell.appendChild(child.getHtmlElement());
        return cell;
    },
    replaceChild : function(index, child) {
        if (index >= this.getChildCount()) {
            throw new Exception('Index out of bounds');
        }
        var row = this.getRow(index / this._fixedSize);
        var num = index % this._fixedSize;
        var cell = row.childNodes[num];
        while (cell.hasChildNodes()) {
            cell.removeChild(cell.firstChild);
        }
        this.removeChild(index);
        cell.appendChild(child.getHtmlElement());
        //this._children.push(child);
        this._children.splice(index, 0, child);
        return child;
    },
    onAddChild : function(child) {
        var cellIndex = (this.getChildCount() - 1) % this._fixedSize;
        Logger.getInstance().trace('onAddChild() cellIndex: ' + cellIndex);
        var row = null;
        if (this._fixedOrientation == 'horizontal') {
            if (cellIndex == 0) {
                //row = this.getRow(Math.floor(this.getChildCount() / this._fixedSize));
                row = this.addRow();
            } else {
                row = this._tableBody.lastChild;
            }
        } else {
            if (this.getChildCount() <= this._fixedSize) {
                //row = this.getRow(Math.floor(this.getChildCount() / this._fixedSize));
                row = this.addRow();
            } else {
                row = this._tableBody.childNodes[cellIndex];
            }
        }
        this.addCell(row, child);
    },
    removeLastChild : function() {
        this.removeChild(this.getChildCount() - 1);
        var rowCount = Math.floor(this.getChildCount() / this._fixedSize);
        while (this._tableBody.childNodes.length > rowCount) {
            this._tableBody.removeChild(this._tableBody.lastChild);
        }
    }
    /*onRemoveChild : function(child) {
        var rowCount = Math.floor(this.getChildCount() / this._fixedSize);
        while (this._tableBody.childNodes.length > rowCount) {
            this._tableBody.removeChild(this._tableBody.lastChild);
        }
    }*/
});

return Table;
});
