define('jls/jsunit/TestResult', ['jls/lang/Class', 'jls/lang/AssertionError', 'jls/jsunit/TestFailure'], function (Class, AssertionError, TestFailure) {

var TestResult;
TestResult = Class.create(
{
    initialize : function() {
		this._errors = [];
        this._failures = [];
        this._runTests = 0;
    },
    run : function(test) {
        this.startTest(test);
        try {
            test.runBare();
        }
        catch (e) {
            if (e instanceof AssertionError) {
                this.addFailure(test, e);
            } else {
                this.addError(test, e);
            }
        }
        this.endTest(test);
    },
    startTest : function(test) {
        this._runTests += test.countTestCases();
    },
    endTest : function(test) {
    },
    addFailure : function(test, e) {
        this._failures.push(new TestFailure(test, e));
    },
    addError : function(test, e) {
        this._errors.push(new TestFailure(test, e));
    },
    errorCount : function() {
		return this._errors.length;
    },
    failureCount : function() {
		return this._failures.length;
    },
    runCount : function() {
		return this._runTests;
    },
    wasSuccessful : function() {
		return this.errorCount() == 0 && this.failureCount() == 0;
    },
    toString : function() {
		return '' + this.runCount() + ' test(s): ' + this.errorCount() + ' error(s) and ' + this.failureCount() + ' failure(s)';
    },
    getErrors : function() {
		return this._errors;
    },
    getFailures : function() {
		return this._failures;
    }
});

return TestResult;
});
