define('spyl/pb/Comment', ['jls/lang/Class'], function (Class) {

var Comment;
Comment = Class.create({
    initialize : function(id, userId, mediaId, content, date) {
        this._id = id;
        this._userId = userId;
        this._mediaId = mediaId;
        this._date = date;
        this._content = content;
    },
    getId : function() {
        return this._id;
    },
    getDate : function() {
        return this._date;
    },
    getUserId : function() {
        return this._userId;
    },
    getMediaId : function() {
        return this._mediaId;
    },
    getContent : function() {
        return this._content;
    }
});

Object.extend(Comment,
{
    createFromXML : function(node) {
        var id = parseInt(node.getAttribute('id'), 10);
        var mediaId = parseInt(node.getAttribute('mediaId'), 10);
        var userId = parseInt(node.getAttribute('userId'), 10);
        var content = node.getAttribute('content');
        var date = new Date(parseInt(node.getAttribute('date'), 10) * 1000);
        return new Comment(id, userId, mediaId, content, date);
    }
});


return Comment;
});
