define('spyl/pb/Context', ['jls/lang/Class'], function (Class) {

var Context;
Context = Class.create({
    initialize: function(viewName, group, mediaIndex) {
        this.viewName = viewName;
        this.group = group;
        this.mediaIndex = mediaIndex;
    },
    createView: function(viewName) {
        return new Context(viewName, this.group, this.mediaIndex);
    },
    createMedia: function(delta) {
        var max = this.group.getMediaCount();
        var index = Math.abs(this.mediaIndex + delta + max) % max;
        return new Context('media', this.group, index);
    },
    getMedia: function() {
        return this.group.getMedia(this.mediaIndex);
    }
});


return Context;
});
