define('spyl/pb/Media', ['jls/lang/Class', 'jls/lang/Exception', 'jls/lang/Logger', 'jls/util/Formatter'],
        function (Class, Exception, Logger, Formatter) {

// Late binding
var Launcher, Comment, PreviewElement, PictureElement, MovieElement;
require(['spyl/pb/Launcher',
         'spyl/pb/Comment',
         'spyl/pb/PreviewElement',
         'spyl/pb/PictureElement',
         'spyl/pb/MovieElement'], function(l, c, p, pic, m) {
    Launcher = l;
    Comment = c;
    PreviewElement = p;
    PictureElement = pic;
    MovieElement = m;
});

var Media;
Media = Class.create({
    initialize : function(id, repositoryId, userId, date, pubDate, description, filename, commentCount) {
        this._id = id;
        this._repositoryId = repositoryId;
        this._userId = userId;
        this._date = date;
        this._pubDate = pubDate;
        this._description = description;
        this._filename = filename;
        this._commentCount = commentCount;
        this._comments = [];
    },
    getTitle : function() {
        var launcher = Launcher.getInstance();
        var title = launcher.formatDate(this._date);
        if (this._description) {
            title += ', ' + this._description;
        }
        //title += ', ' + this._filename;
        title += ', ' + launcher.users[this._userId].login;
        if (this._commentCount > 0) {
            title += ', ' + this._commentCount + ' ';
            if (this._commentCount > 1) {
                title += launcher.commentsLabel;
            } else {
                title += launcher.commentLabel;
            }
        }
        return title;
    },
    getId : function() {
        return this._id;
    },
    getRepositoryId : function() {
        return this._repositoryId;
    },
    getDate : function() {
        return this._date;
    },
    addComment : function(comment) {
        this._comments.push(comment);
    },
    newComment : function(userId, content) {
        this._comments.push(new Comment(-1, userId, this._id, content, new Date()));
        this._commentCount++;
    },
    clearComments : function() {
        this._comments = [];
    },
    getCommentCount : function() {
        return this._commentCount;
    },
    getComments : function() {
        return this._comments;
    },
    getBasePathname: function() {
        return Formatter.format('repository/%02d/%d/', this._repositoryId, this._date.getFullYear());
    },
    getExtension: function() {
        return '';
    },
    getPathname: function() {
        return this.getBasePathname() + Formatter.format('%03d', this._id) + this.getExtension();
    },
    getMiniaturePathname: function() {
        return this.getBasePathname() + Formatter.format('mini/%03d.jpg', this._id);
    },
    createMiniature : function(params, parent) {
        Logger.getInstance().trace('createMiniature()');
        return new PreviewElement(params, parent);
    }
});

Object.extend(Media,
{
    compareMedias : function(a, b) {
        if (a._date < b._date)
            return -1;
        if (a._date > b._date)
            return 1;
        return 0;
    },
    compareMediasByPubDate : function(a, b) {
        if (a._pubDate < b._pubDate)
            return -1;
        if (a._pubDate > b._pubDate)
            return 1;
        return 0;
    },
    createFromXML : function(node) {
        var id = parseInt(node.getAttribute('id'), 10);
        var repositoryId = parseInt(node.getAttribute('repositoryId'), 10);
        var type = node.getAttribute('type');
        var userId = parseInt(node.getAttribute('userId'), 10);
        var filename = node.getAttribute('filename');
        var description = node.getAttribute('description');
        var date = new Date(parseInt(node.getAttribute('date'), 10) * 1000);
        var pubDate = new Date(parseInt(node.getAttribute('pubDate'), 10) * 1000);
        var commentCount = parseInt(node.getAttribute('commentCount'), 10);
        switch (type) {
        case 'picture':
            return new Media.Picture(id, repositoryId, userId, date, pubDate, description, filename, commentCount);
        case 'movie':
            return new Media.Movie(id, repositoryId, userId, date, pubDate, description, filename, commentCount);
        }
        throw new Exception('Invalid media type (' + type + ')');
    }
});

Media.Picture = Class.create(Media,
{
    createElement : function(params, parent) {
        return new PictureElement(params, parent);
    },
    getExtension: function() {
        return '.jpg';
    }
});

Media.Movie = Class.create(Media,
{
    createElement : function(params, parent) {
        return new MovieElement(params, parent);
    },
    getExtension: function() {
        return '.flv';
    }
});


return Media;
});
