define('spyl/pb/PreviewElement', ['jls/lang/Class', 'jls/lang/Logger', 'jls/html/HtmlElement'], function (Class, Logger, HtmlElement) {

var PreviewElement;
PreviewElement = Class.create(HtmlElement,
{
    initialize : function($super, parameters, parent) {
        Logger.getInstance().trace('PreviewElement.constructor()');
        parameters = parameters || {};
        this._group = 'group' in parameters ? parameters.group : null;
        this._index = 'index' in parameters ? parameters.index : -1;
        this._media = 'media' in parameters ? parameters.media : this._group.getMedia(this._index);
        $super(parameters, parent);
    },
    onCreateHtmlElement : function() {
        var htmlElement = document.createElement('img');
        htmlElement.setAttribute('src', this._media.getMiniaturePathname());
        htmlElement.setAttribute('title', this._media.getTitle());
        return htmlElement;
    },
    getMedia : function() {
        return this._media;
    },
    getIndex : function() {
        return this._index;
    },
    getGroup : function() {
        return this._group;
    }
});


return PreviewElement;
});
