define('spyl/pb/Repository', ['jls/lang/Class', 'jls/lang/Logger'], function (Class, Logger) {

var Repository;
Repository = Class.create(
{
    initialize : function(id, title, userId, description, requiresUserAccess, isPublic, rights) {
        this.id = id;
        this.title = title;
        this.userId = userId;
        this.description = description;
        this.requiresUserAccess = requiresUserAccess ? true : false;
        this.isPublic = isPublic ? true : false;
        // User repository fields
        this.rights = rights || null;
        //this.isSubscribed = false;
    },
    getRights : function() {
        return this.rights;
    },
    setRights : function(rights) {
        this.rights = rights || null;
        return this;
    },
    clone : function() {
        return new Repository(
                this.id,
                this.title,
                this.userId,
                this.description,
                this.requiresUserAccess,
                this.isPublic,
                this.rights
                );
    },
    equals : function(b) {
        if (b === this) {
            return true;
        }
        return (b.id == this.id) && (b.title == this.title) && (b.userId == this.userId) &&
            (b.description == this.description) && (b.requiresUserAccess == this.requiresUserAccess) &&
            (b.isPublic == this.isPublic);
    }
});

Object.extend(Repository,
{
    createFromXML : function(node) {
        return new Repository(
                parseInt(node.getAttribute('id'), 10),
                node.getAttribute('title'),
                parseInt(node.getAttribute('userId'), 10),
                node.getAttribute('description'),
                node.getAttribute('requiresUserAccess') == 'true',
                node.getAttribute('isPublic') == 'true'
                );
    }
});

return Repository;
});
