define('spyl/pb/ViewportElement', ['jls/lang/Class', 'jls/lang/Logger', 'jls/html/HtmlElement'], function (Class, Logger, HtmlElement) {

var ViewportElement;
ViewportElement = Class.create(HtmlElement,
{
    initialize : function($super, parameters, parent) {
        $super(parameters, parent);
        this.borderedFix = this.getById('bordered_fix');
        this.borderedAuto = this.getById('bordered_auto');
        this.borderedFixRow = this.getById('bordered_fix_row');
        this.borderedAutoRow = this.getById('bordered_auto_row');
    },
    onCreate : function($super) {
        this.setAttribute('htmlTagName', 'div')
        $super();
    },
    openMedia: function() {
    	this.borderedAutoRow.getStyle().setProperty('display', 'none');
        this.borderedFix.removeChildren();
        this.borderedAuto.removeChildren();
        this.borderedFixRow.getStyle().setProperty('display', '');
        return this.borderedFix;
    },
    openComment: function() {
        this.borderedAuto.removeChildren();
        this.borderedAutoRow.getStyle().setProperty('display', '');
        return this.borderedAuto;
    },
    openBoard: function() {
        this.borderedAuto.removeChildren();
        this.borderedFixRow.getStyle().setProperty('display', 'none');
        this.borderedAutoRow.getStyle().setProperty('display', '');
        return this.borderedAuto;
    },
    openGroup: function() {
        this.borderedAuto.removeChildren();
        this.borderedFixRow.getStyle().setProperty('display', 'none');
        this.borderedAutoRow.getStyle().setProperty('display', '');
        //this.borderedAuto.getStyle().removeProperty('display');
        return this.borderedAuto;
    }
});


return ViewportElement;
});
