define('spyl/pb/ViewportMobileElement', ['jls/lang/Class', 'jls/lang/Logger', 'jls/html/HtmlElement'], function (Class, Logger, HtmlElement) {

var ViewportMobileElement;
ViewportMobileElement = Class.create(HtmlElement,
{
    initialize : function($super, parameters, parent) {
        $super(parameters, parent);
        this.container = this.getById('container');
        this.mediaContainer = this.getById('mediaContainer');
        this.media = this.mediaContainer.getById('media');
        this.comments = this.mediaContainer.getById('comments');
    	this.containerDisplay = this.container.getStyle().getPropertyValue('display');
    },
    onCreate : function($super) {
        this.setAttribute('htmlTagName', 'div')
        $super();
    },
    openMedia: function() {
    	this.container.getStyle().setProperty('display', 'none');
    	this.comments.getStyle().setProperty('display', 'none');
    	this.mediaContainer.getStyle().setProperty('display', '');
        this.media.removeChildren();
        return this.media;
    },
    openComment: function() {
        this.comments.removeChildren();
    	this.comments.getStyle().setProperty('display', '');
        return this.comments;
    },
    openBoard: function() {
    	this.container.removeChildren();
    	this.container.getStyle().setProperty('display', this.containerDisplay);
    	this.mediaContainer.getStyle().setProperty('display', 'none');
        return this.container;
    },
    openGroup: function() {
        return this.openBoard();
    }
});


return ViewportMobileElement;
});
