<html>
<head>
<title>PhotoBlog - Setup</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
</head>
<body>
<h1>Configuration</h1>
<form action="setup.php" method="post">
<?php

$adminPassword = 'changeit';
//$sitePath = '';
$sitePath = str_replace('script/setup.php', '', $_SERVER['REQUEST_URI']);
$sitePath = substr($sitePath, 1);

$freedotfrFlag = (strrpos($_SERVER['SERVER_NAME'], '.free.fr', 0) === (strlen($_SERVER['SERVER_NAME']) - 8));

$htaccessPath = '../www/';
$htaccessFormat = '"AuthType Basic\nAuthName \\"By Invitation Only\\"\\nAuthUserFile " . HTACCESS_PATH . "%s\\nRequire valid-user\n"';
if ($freedotfrFlag) {
    $htaccessPath = '';
    $htaccessFormat = '"AuthType Basic\nAuthName \\"By Invitation Only\\"\\nPerlSetVar AuthFile " . HTACCESS_PATH . "%s\\nRequire valid-user\n"';
}

$baseVariables = array(
    'DB_HOST' => '127.0.0.1',
    'DB_USER' => 'jls',
    'DB_PASSWORD' => 'jls',
    'DB_NAME' => 'jls',
    'DB_PREFIX' => 'PB_',
    'ADMIN_LOGIN' => 'admin',
    'ADMIN_PASSWORD' => $adminPassword,
    'ADMIN_EMAIL' => 'admin@localhost',
    'SITE_NAME' => 'Photo Blog',
    // SERVER_NAME SERVER_PORT REMOTE_ADDR REMOTE_HOST REMOTE_PORT
    'SITE_ADDRESS' => 'http://' . $_SERVER['SERVER_NAME'] . ':' . $_SERVER['SERVER_PORT'] . '/',
    'SITE_PATH' => $sitePath,
    'PB_LANGUAGE' => 'en',
    'HTACCESS_PATH' => $htaccessPath
);
$extVariables = array(
    'PB_PATH' => "'../'",
    'SCRIPTS_PATH' => "'script'",
    'REPOSITORY_PATH' => "'repository'",
    'INCOMING_PATH' => "'incoming'",
    'HTACCESS_FORMAT' => $htaccessFormat,
    'USER_HTPASSWD_FILE' => "'.htpasswd'",
    'PRIVATE_ACCESS_FILE' => "'access.php'",
    'SITE_FULL_ADDRESS' => "SITE_ADDRESS . SITE_PATH",
    'PB_REPOSITORY_PATH' => "PB_PATH . REPOSITORY_PATH",
    'PB_INCOMING_PATH' => "PB_PATH . INCOMING_PATH"
);

$action = NULL;
if (array_key_exists("action", $_POST)) {
    $action = $_POST["action"];
}
switch ($action) {
case "create":
    if (array_key_exists('ADMIN_PASSWORD', $_POST)) {
        $adminPassword = $_POST['ADMIN_PASSWORD'];
        unset($_POST['ADMIN_PASSWORD']);
    }
    $userVariables = array();
    foreach (array_keys($baseVariables) as $field) {
        if (array_key_exists($field, $_POST)) {
            $userVariables[$field] = "'" . $_POST[$field] . "'";
        } else {
            $userVariables[$field] = "'" . $baseVariables[$field] . "'";
        }
    }
    $variables = array_merge($userVariables, $extVariables);
    $file = fopen('globals.php', 'w');
    fwrite($file, "<?php\n");
    foreach ($variables as $key => $value) {
        fwrite($file, "define('" . $key . "', " . $value . ");\n");
    }
    fwrite($file, "?>\n");
    fclose($file);

    require_once('init.php');

    init_initialize($adminPassword);

    $publicRepository = pb_Repository::fetchFromId(1);
    $repository = pb_Repository::fetchFromId(2);
    $adminUser = pb_User::fetchFromLogin(ADMIN_LOGIN);

    $misc = $repository->getFolder() . '/misc';
    $uploader = 'pb-uploader.zip';
    Helper::mkdir($misc);
    rename(PB_PATH . $uploader, $misc . '/' . $uploader);

    $file = new util_UploadedFile('mug.jpg', PB_PATH . 'mug.jpg', FALSE);
    $mini = new util_UploadedFile('mugm.jpg', PB_PATH . 'mugm.jpg', FALSE);
    $media = new pb_Media(pb_Media::$TYPE_PICTURE, $file->getName(), time(), $adminUser->getId(), $publicRepository->getId(), NULL, 'Welcome', time());
    $media->create($file, $mini);
    
    if (is_file(PB_PATH . 'index.php')) {
        unlink(PB_PATH . 'index.php');
        rename(PB_PATH . 'gindex.php', PB_PATH . 'index.php');
    }

    echo "<p>Photo Blog initialized</p>\n";
    echo "<p>You could log as " . ADMIN_LOGIN . " or guest/guest</p>\n";
    echo '<a href="' . SITE_FULL_ADDRESS . '">click here to access</a><br><br>' . "\n";
    break;
default:
?>
<table>
<?php
    foreach ($baseVariables as $key => $value) {
        echo '<tr><td><label>' . $key . '</label></td><td><input type="text" name="' . $key . '" value="' . $value . '"></td></tr>' . "\n";
    }
?>
</table>
<input type=submit name="action" value="create">
<?php
    break;
}
?>
</form>
</body>
</html>
