<?php
/*
 * SQL
 */
class sql_ResultSet {
    protected $resultSet;
    protected $currentRow = NULL;
    protected $fetchAsObject = TRUE;

    public function __construct($resultSet) {
        $this->resultSet = $resultSet;
    }
    public function isFetchAsObject() {
        return $this->fetchAsObject;
    }
    public function setFetchAsObject($fetchAsObject) {
        $this->fetchAsObject = (bool) $fetchAsObject;
    }
	function next() {
        $this->currentRow = NULL;
        if ($this->fetchAsObject) {
            $row = mysql_fetch_object($this->resultSet);
        } else {
            $row = mysql_fetch_row($this->resultSet);
        }
        if ($row == false) {
            return false;
        }
        $this->currentRow = $row;
        return true;
	}
	function getRowObject() {
        return $this->currentRow;
	}
}

class sql_Connection {
    protected $connection;
    protected $resultSet = NULL;
    protected $inTransaction = false;

    public function __construct($server, $username, $password, $databaseName) {
        $this->connection = mysql_pconnect($server, $username, $password);
        if ($this->connection == false) {
            throw new Exception("Cannot connect " . $username . "@" . $server);
        }
        if (! mysql_select_db($databaseName, $this->connection)) {
            throw new Exception("Cannot select database " . $databaseName . " due to " . mysql_error($this->connection));
        }
        mysql_query('SET NAMES \'utf8\'', $this->connection);
    }
    function isInTransaction() {
        return $this->inTransaction;
    }
    function query($sql) {
        $result = mysql_query($sql, $this->connection);
        if ($result == false) {
            throw new Exception("Fail to execute \"" . $sql . "\" due to " . mysql_error($this->connection));
        }
        //echo "<!-- SQL execute($sql) -->";
        return $result;
    }
	function execute($sql) {
        $this->resultSet = NULL;
        $result = $this->query($sql);
        $this->resultSet = new sql_ResultSet($result);
        if (! $result) {
            return false;
        }
        return true;
	}
	function executef() {
        $numargs = func_num_args();
        $sqlf = NULL;
        if ($numargs > 1) {
	        $format = func_get_arg(0);
	        $escapeWildcards = false; //strpos($format, ' LIKE ') === false;
            $args = array();
            for ($i = 1; $i < $numargs; $i++) {
                $arg = func_get_arg($i);
                if (is_string($arg)) {
                    $arg = mysql_real_escape_string($arg, $this->connection);
	                if ($escapeWildcards) {
	                    $arg = sql_Connection::escapeWildcards($arg);
	                }
                }
                $args[] = $arg;
            }
            $sqlf = vsprintf($format, $args);
        } else {
            $sqlf = func_get_arg(0);
        }
        return $this->execute($sqlf);
	}
	function getResultSet() {
        return $this->resultSet;
	}
	function begin() {
        //$this->query('SET AUTOCOMMIT=0');
        $this->query('START TRANSACTION');
        $this->inTransaction = true;
	}
	function commit() {
        $this->query('COMMIT');
        $this->inTransaction = false;
	}
	function rollback() {
        $this->query('ROLLBACK');
        $this->inTransaction = false;
	}
	function getUpdateCount() {
        //mysql_num_rows
        return mysql_affected_rows($this->connection);
    }
    function lastInsertId() {
        //return mysql_insert_id($this->connection);
        return mysql_result($this->query('SELECT LAST_INSERT_ID()'), 0);
    }
    public static function escapeWildcards($value) {
        return str_replace('%' , '\%', str_replace('_' , '\_', $value));
	}
    /*
     * See http://dev.mysql.com/doc/refman/5.0/en/date-and-time-functions.html
     */
    public static function fromTimestamp($value) {
        return 'FROM_UNIXTIME(' . $value . ')';
	}
    public static function toTimestamp($name, $alias = NULL) {
        if ($alias == NULL) {
            $alias = $name;
        }
        return 'UNIX_TIMESTAMP(' . $name . ') AS ' . $alias;
	}
}

?>